<?php

declare(strict_types=1);

namespace Storage\Doctrine\Entity\Traits;

use Doctrine\ORM\Mapping as ORM;

trait AutoIncrementPrimaryKeyEntityTrait
{
    /** @var int */
    #[
        ORM\Id,
        ORM\GeneratedValue,
        ORM\Column(name: 'id', type: 'integer', unique: true, nullable: false),
    ]
    protected $id;

    public function getId(): int
    {
        return $this->id;
    }
}
