<?php

declare(strict_types=1);

namespace Core\General\Validation\ValueObject;

use Core\General\Translation\ValueObject\TranslationTuple;

final readonly class RegexCondition
{
    public function __construct(
        private string $expression,
        private string|TranslationTuple $errorMessage,
    ) {
    }

    public function getExpression(): string
    {
        return \sprintf('/%s/', $this->expression);
    }

    public function getErrorMessage(): string|TranslationTuple
    {
        return $this->errorMessage;
    }
}
