<?php

declare(strict_types=1);

namespace Core\General\Pagination\ValueObject;

final class EmptyPaginatedSet extends PaginatedSet
{
    public function __construct(
        public readonly ?int $limit = null,
        public readonly int $offset = 0,
    ) {
        parent::__construct(
            results: [],
            totalResults: 0,
            limit: $limit,
            offset: $offset,
        );
    }
}
