<?php

declare(strict_types=1);

namespace Core\General\Database\Enum;

use Core\General\Enum\BaseEnum;

final class OrderType extends BaseEnum
{
    public const ASC = 'ASC';
    public const DESC = 'DESC';

    /** @var string[] */
    protected static array $labels = [
        self::ASC => 'Ascending',
        self::DESC => 'Descending',
    ];
}
