<?php

declare(strict_types=1);

namespace Core\Framework\Message;

use Core\Framework\Message\Exception\MessageException;
use Symfony\Component\Messenger\Exception\ExceptionInterface;
use Symfony\Component\Messenger\MessageBusInterface;

/**
 * Wrapper around Symfony's message dispatcher
 */
readonly class MessageBus
{
    public function __construct(
        private MessageBusInterface $messageDispatcher,
    ) {
    }

    /**
     * @throws MessageException - it can be thrown in handlers
     */
    public function dispatch(Message $message): void
    {
        try {
            $this->messageDispatcher->dispatch($message);
        } catch (ExceptionInterface $e) {
            throw MessageException::becauseUnexpectedErrorOccurred($e->getMessage());
        }
    }
}
